/*-------------------------------------------------------------------------+
| Copyright 2014 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

/**
 * {@link IContextMenuContributor} which supports multiple selected {@link EObject}s.
 * 
 * @author andrei
 */
public interface IContextMenuMultiSelectionContributor extends IContextMenuContributor {
	/**
	 * Returns the contributed items, i.e., actions or menus in the context of
	 * the given provider and the given selected model element. The selection
	 * may be null, but is always equal to
	 * {@link ContextMenuContextProvider#getSelectedModelElement()}.
	 */

	List<IContributionItem> getContributedItems(List<EObject> selection,
			ContextMenuContextProvider contextProvider);
}
