/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;

/**
 * Kernel specific extension of Eclipse {@link IEditorPart}.
 * 
 * @author hoelzl
 */
public interface IModelEditor<T extends EObject> extends IEditorPart {
	/** Returns the edited object. */
	T getEditedObject();

	/**
	 * Navigates to the given element in the editor so that the element is visible to the user.
	 * Typically, this would amount to scrolling the editor to bring the element into view.
	 */
	void navigateTo(EObject element);

	/** Sets the highlighting of the given model element to the given value. */
	void setHighlight(EObject element, boolean highlighted);

	/** Clears all highlightings from the editor. */
	void clearAllHighlights();
}
