/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IControllerFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;
import org.fortiss.tooling.kernel.service.base.IEObjectAware;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;

/**
 * Interface for editor bindings. An editor binding a defines a model element
 * editor. Usually, an editor (in the Eclipse interpretation) is a view (in the
 * model-based development interpretation) on the underlying model.
 * <p>
 * This interface also specifies bindings to those MVC factories that are responsible for the
 * interaction of the editor with the model, its presentation, and behavior.
 * <p>
 * Each editor provided by some binding becomes part of an Eclipse multi-page editor. Its page
 * carries the name delivered by {@link #getLabel}. The {@link IModelEditorBindingService} sorts the
 * provided editors according to their priority returned by {@link #getPriority} with higher values
 * having lower priority.
 * <b>NOTE:</b>: The priority reported by {@link #getPriority()} is also used to define the order in
 * which the factories are traversed.
 * 
 * @see IModelEditorBindingService
 * 
 * @author hoelzl
 */
public interface IModelEditorBinding<T extends EObject> extends IEObjectAware<EObject> {

	/** Returns the class of the editor registered by this binding. */
	Class<? extends IEditorPart> getEditorClass(T object);

	/** Returns the {@link IModelFactory} to instantiate for the {@link IEditorPart}. */
	Class<? extends IModelFactory> getModelFactory();

	/** Returns the {@link IVisualFactory} to instantiate for the {@link IEditorPart}. */
	Class<? extends IVisualFactory> getVisualFactory();

	/** Returns the {@link IControllerFactory} to instantiate for the {@link IEditorPart}. */
	Class<? extends IControllerFactory> getControllerFactory();

	/** Returns the label of the editor. */
	String getLabel(T object);

	/** Returns the priority of the editor. Higher values have lower priority. */
	int getPriority();

	/**
	 * Returns {@code true} if the editor referenced by this editor binding should be hidden in the
	 * navigator's simplified non-expert view.
	 */
	boolean hiddenInNonExpertView();
}
