/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension;

import org.eclipse.swt.widgets.Composite;
import org.fortiss.tooling.kernel.extension.ITutorialStep;
import org.fortiss.tooling.kernel.ui.internal.editor.TutorialStepUIDefaultGUI;

/**
 * Interface for the UI part of tutorial steps.
 * 
 * @author hoelzl
 */
public interface ITutorialStepUI extends ITutorialStep {
	/**
	 * Returns the short title for this tutorial step. Sub-classes may override. The default is
	 * equal to {@link #getTitle()}.
	 */
	String getShortTitle();

	/**
	 * Creates the composite to be shown in the editor for the given tutorial step. Sub-classes may
	 * override. Base classes create {@link TutorialStepUIDefaultGUI} instances.
	 */
	void createDetailsComposite(Composite parent);
}
