/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;

/**
 * Tutorial whitelist provider interface for the tutorial UI kernel services.
 * 
 * @author hoelzl
 */
public interface ITutorialUIWhitelistProvider {
	/** Returns whether the given element should be displayed in the navigator tree. */
	boolean elementVisibleInNavigator(EObject element);

	/** Returns whether the global copy and paste actions are visible in the context menu. */
	boolean globalCopyPasteActionsVisible();

	/** Returns whether the global undo and redo actions are visible in the context menu. */
	boolean globalUndoRedoActionsVisible();

	/** Returns whether the global delete action is visible in the context menu. */
	boolean globalDeleteActionVisible();

	/** Returns whether the global rename action is visible in the context menu. */
	boolean globalRenameActionVisible();

	/** Returns whether the global "select all" action is visible in the context menu. */
	boolean globalSelectAllActionVisible();

	/** Returns whether the given context menu contribution is visible. */
	boolean contextMenuContributionVisible(EObject element, IContributionItem contribution);
}
