/*-------------------------------------------------------------------------+
| Copyright 2015 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import static org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended.showErrorInUIThread;
import static org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended.showInfoInUIThread;
import static org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended.showWarningInUIThread;

import org.fortiss.tooling.kernel.extension.ILogMessageHandler;
import org.fortiss.tooling.kernel.extension.base.DialogMessage;
import org.fortiss.tooling.kernel.extension.data.ILogMessageContext;

/**
 * {@link ILogMessageHandler} that displays messages to a user in a dialog. It is used by backend
 * plugins that may not have dependencies on UI plugins.
 * 
 * @author diewald
 */
public class DialogMessageHandler implements ILogMessageHandler<DialogMessage> {

	/** {@inheritDoc} */
	@Override
	public void showMessage(DialogMessage message, ILogMessageContext context) {
		if(message != null) {
			switch(message.getSeverity()) {
				case ERROR:
					showErrorInUIThread("Error", message.getMessage());
					break;
				case WARNING:
					showWarningInUIThread("Warning", message.getMessage());
					break;
				case INFORMATION:
					showInfoInUIThread("Information", message.getMessage());
					break;
			}
		}
	}
}
