/*-------------------------------------------------------------------------+
| Copyright 2018 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/**
 * Interface for property sections in which a list of elements can be edited.
 * 
 * @author barner
 */
public interface IListPropertySection<I extends EObject, R extends EObject> {

	/** Returns the {@link List} of elements in the edited {@link EReference} list. */
	public List<R> getModelListElements(I input);

	/** Adds the given {@code element} to the edited {@link EReference} list. */
	public void addModelListElement(I input, R element);

	/** Removes the given {@code element} from the edited {@link EReference} list. */
	public void removeModelListElement(I input, R element);

	/** Predicate if the given {@code element} may be removed from the list. */
	public boolean canRemoveModelListElement(I input, R element);

	/** Returns the currently selected element of the viewer used to edit the element list. */
	public R getSelectedElement();

	/** Returns the input model that contains the edited list. */
	public I getSectionInput();

	/** Updates the list viewer and the property section that embeds it. */
	public void refresh();
}
