/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IControllerFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;
import org.fortiss.tooling.kernel.service.base.IEObjectAware;
import org.fortiss.tooling.kernel.ui.extension.IModelEditorBinding;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;

/**
 * Interface for editor bindings. An editor binding a defines a model element
 * editor. Usually, an editor (in the Eclipse interpretation) is a view (in the
 * model-based development interpretation) on the underlying model.
 * 
 * <P>
 * Each editor provided by some binding becomes part of an Eclipse multi-page editor. Its page
 * carries the name delivered by {@link #getLabel()}. The {@link IModelEditorBindingService} sorts
 * the provided editors according to their priority returned by {@link #getPriority()} with higher
 * values having lower priority.
 * 
 * @see IModelEditorBindingService
 * 
 * @author hoelzl
 * @author diewald
 */
public abstract class ModelEditorBindingBase<T extends EObject>
		implements IEObjectAware<EObject>, IModelEditorBinding<T> {
	/** Returns the class of editor */
	@Override
	public java.lang.Class<? extends org.eclipse.ui.IEditorPart> getEditorClass(T object) {
		return getEditorClass();
	}

	/** Returns the class of editor */
	public java.lang.Class<? extends org.eclipse.ui.IEditorPart> getEditorClass() {
		return getEditorClass(null);
	}

	/** {@inheritDoc} */
	@Override
	public Class<? extends IModelFactory> getModelFactory() {
		throw new UnsupportedOperationException("This method shall only be called from FX" +
				" editors. Ensure to define the model factory in the editor binding. Remove" +
				" this method when the ediors are migrated to JavaFX.");
	}

	/** {@inheritDoc} */
	@Override
	public Class<? extends IVisualFactory> getVisualFactory() {
		throw new UnsupportedOperationException("This method shall only be called from FX" +
				" editors. Ensure to define the visual factory in the editor binding. Remove" +
				" this method when the ediors are migrated to JavaFX.");
	}

	/** {@inheritDoc} */
	@Override
	public Class<? extends IControllerFactory> getControllerFactory() {
		throw new UnsupportedOperationException("This method shall only be called from FX" +
				" editors. Ensure to define the controller factory in the editor binding. Remove" +
				" this method when the ediors are migrated to JavaFX.");
	}

	/** Returns the label of editor */
	@Override
	public String getLabel(T object) {
		return getLabel();
	}

	/** Returns the label of editor */
	public String getLabel() {
		return getLabel(null);
	}

	/** Returns the priority of the editor. Higher values have higher priority. */
	@Override
	public int getPriority() {
		return 0;
	}

	/** {@inheritDoc} */
	@Override
	public boolean hiddenInNonExpertView() {
		return false;
	}
}
