/*-------------------------------------------------------------------------+
| Copyright 2014 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * Support for multi object selection.
 * 
 * @author andrei
 */
public abstract class MultiEObjectActionBase<T extends List<? extends EObject>> extends Action {

	/** Stores the target element. */
	private T target;

	/** Constructor. */
	public MultiEObjectActionBase(String text, ImageDescriptor image) {
		super(text, image);
	}

	/** Constructor. */
	public MultiEObjectActionBase(T target, String text, ImageDescriptor image) {
		this(text, image);
		refresh(target);
	}

	/** Constructor. */
	public MultiEObjectActionBase(T target, String text) {
		this(target, text, null);
	}

	/** Sets the target object. */
	public void setTarget(T target) {
		this.target = target;
	}

	/** Returns the current target. */
	public T getTarget() {
		return target;
	}

	/** Refreshes the enabled state for the current action target. */
	public final void refresh() {
		if(getTarget() == null || getTarget().isEmpty()) {
			setEnabled(false);
			return;
		}
		setEnabled(computeEnabled());
	}

	/**
	 * Refreshes the action's target and enabled state.
	 * 
	 * @see #setTarget(List)
	 * @see #refresh()
	 */
	public final void refresh(T element) {
		setTarget(element);
		refresh();
	}

	/**
	 * Computes the enabled state of the action for the current target, which is
	 * not <code>null</code> when this method is called. The default
	 * implementation returns <code>true</code>.
	 */
	protected boolean computeEnabled() {
		return true;
	}
}
