/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;

/**
 * {@link IModelElementHandler} base implementation for {@link INamedCommentedElement}s.
 * 
 * @author hoelzlf
 */
public abstract class NamedCommentedModelElementHandlerBase<T extends INamedCommentedElement>
		extends ModelElementHandlerBase<T> {

	/** {@inheritDoc} */
	@Override
	public String getName(T element) {
		if(element.getName() == null) {
			return "";
		}
		return element.getName();
	}

	/** {@inheritDoc} */
	@Override
	public String getDescription(T element) {
		if(element.getComment() == null) {
			return "";
		}
		return element.getComment();
	}
}
