/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.tooling.kernel.extension.data.TutorialAtomicStep;
import org.fortiss.tooling.kernel.ui.extension.ITutorialStepUI;
import org.fortiss.tooling.kernel.ui.internal.editor.TutorialStepUIDefaultGUI;

/**
 * Base class for UI parts of {@link TutorialAtomicStep}s.
 * 
 * @author hoelzl
 */
public abstract class TutorialStepUIAtomicBase extends TutorialAtomicStep
		implements ITutorialStepUI {
	/** Constructor. */
	public TutorialStepUIAtomicBase(String title) {
		super(title);
	}

	/** Constructor. */
	public TutorialStepUIAtomicBase(String title, String url) {
		super(title, url);
	}

	/** {@inheritDoc} */
	@Override
	public String getShortTitle() {
		return getTitle();
	}

	/** {@inheritDoc} */
	@Override
	public void createDetailsComposite(Composite parent) {
		TutorialStepUIDefaultGUI gui = new TutorialStepUIDefaultGUI(parent, SWT.NONE);
		gui.getDescriptionBrowser().setUrl(getUrl());
	}
}
