/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.fortiss.tooling.kernel.ui.extension.ITutorialUIWhitelistProvider;

/**
 * Base class combining {@link TutorialStepUIAtomicBase} and {@link ITutorialUIWhitelistProvider}.
 * All tutorial elements are enabled (whitelisted) and sub-classes should selectively disable the
 * relevant portions.
 * 
 * @author hoelzl
 */
public abstract class TutorialStepUIAtomicWithWhitelistBase extends TutorialStepUIAtomicBase
		implements ITutorialUIWhitelistProvider {
	/** Constructor. */
	public TutorialStepUIAtomicWithWhitelistBase(String title) {
		super(title);
	}

	/** Constructor. */
	public TutorialStepUIAtomicWithWhitelistBase(String title, String description) {
		super(title, description);
	}

	/** {@inheritDoc} */
	@Override
	public boolean elementVisibleInNavigator(EObject element) {
		return true;
	}

	/** {@inheritDoc} */
	@Override
	public boolean globalCopyPasteActionsVisible() {
		return true;
	}

	/** {@inheritDoc} */
	@Override
	public boolean globalDeleteActionVisible() {
		return true;
	}

	/** {@inheritDoc} */
	@Override
	public boolean globalUndoRedoActionsVisible() {
		return true;
	}

	/** {@inheritDoc} */
	@Override
	public boolean globalRenameActionVisible() {
		return true;
	}

	/** {@inheritDoc} */
	@Override
	public boolean globalSelectAllActionVisible() {
		return true;
	}

	/** {@inheritDoc} */
	@Override
	public boolean contextMenuContributionVisible(EObject element, IContributionItem contribution) {
		return true;
	}
}
