/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.tooling.kernel.extension.data.TutorialCompositeStep;
import org.fortiss.tooling.kernel.extension.data.TutorialStepBase;
import org.fortiss.tooling.kernel.ui.extension.ITutorialStepUI;
import org.fortiss.tooling.kernel.ui.internal.editor.TutorialStepUIDefaultGUI;

/**
 * Data class for UI parts of {@link TutorialStepBase}s.
 * 
 * @author hoelzl
 */
public abstract class TutorialStepUICompositeBase extends TutorialCompositeStep
		implements ITutorialStepUI {
	/** Constructor. */
	public TutorialStepUICompositeBase(String title, TutorialStepBase firstStep) {
		super(title, firstStep);
	}

	/** Constructor. */
	public TutorialStepUICompositeBase(String title, String url, TutorialStepBase firstStep) {
		super(title, url, firstStep);
	}

	/** {@inheritDoc} */
	@Override
	public String getShortTitle() {
		return getTitle();
	}

	/** {@inheritDoc} */
	@Override
	public void createDetailsComposite(Composite parent) {
		TutorialStepUIDefaultGUI gui = new TutorialStepUIDefaultGUI(parent, SWT.NONE);
		gui.getDescriptionBrowser().setUrl(getUrl());
	}
}
