/*-------------------------------------------------------------------------+
| Copyright 2019 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.base.factory;

import java.util.List;

import org.eclipse.ui.IEditorPart;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IDiagramAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;
import org.fortiss.tooling.kernel.service.ITransformationService;
import org.fortiss.tooling.kernel.ui.extension.base.LWFXEFEditorBase;

/**
 * Base class for {@link IVisualFactory}s of extendable {@link LWFXEFEditorBase}
 * {@link IEditorPart}s.The first non-{@code null} element returned by the factories of the
 * initially given list is returned. If no element is created (all delegates returned null), this
 * factory also returns {@code null}.
 * <P>
 * This class uses the {@link ITransformationService} to find a delegate visual factory for the
 * model elements in question.
 * 
 * @author hoelzl
 */
public class DelegatingVisualFactory extends DelegatingFactoryBase<IVisualFactory>
		implements IVisualFactory {

	/** Constructor. */
	public DelegatingVisualFactory(List<Class<? extends IVisualFactory>> factories) {
		super(factories, null);
	}

	/** {@inheritDoc} */
	@Override
	public IContentVisual createContentVisual(IContentMVCBundle modelBundle) {
		return getDelegateFactories().stream().map(f -> f.createContentVisual(modelBundle))
				.filter(cc -> cc != null).findFirst().orElse(null);
	}

	/** {@inheritDoc} */
	@Override
	public IDiagramAnchorageVisual
			createDiagramAnchorageVisual(IDiagramAnchorageMVCBundle modelBundle) {
		return getDelegateFactories().stream().map(f -> f.createDiagramAnchorageVisual(modelBundle))
				.filter(cc -> cc != null).findFirst().orElse(null);
	}

	/** {@inheritDoc} */
	@Override
	public IContentAnchorageVisual
			createContentAnchorageVisual(IContentAnchorageMVCBundle modelBundle) {
		return getDelegateFactories().stream().map(f -> f.createContentAnchorageVisual(modelBundle))
				.filter(cc -> cc != null).findFirst().orElse(null);
	}

	/** {@inheritDoc} */
	@Override
	public ILinkVisual createLinkVisual(ILinkMVCBundle modelBundle) {
		return getDelegateFactories().stream().map(f -> f.createLinkVisual(modelBundle))
				.filter(cc -> cc != null).findFirst().orElse(null);
	}
}
