/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension.data;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.internal.ContextMenuService;

/**
 * Instances of this class provide context information to the {@link ContextMenuService}. During
 * creation or update of a context menu, every {@link IContextMenuContributor} is given the chance
 * to contribute menus and action to the pop-up menu. This decision may take into account, which
 * subclass of this class is or was used during the creation of the context
 * menu. Hereby, a contributor may provide actions and menus only to certain
 * views or editors, or certain selection or application state criteria.
 * 
 * @author hoelzl
 */
public interface ContextMenuContextProvider {

	/**
	 * Returns the selected model element given to contributors during menu
	 * creation or update.
	 */
	EObject getSelectedModelElement();

	/**
	 * Returns a list containing the selected Eobjects
	 */
	List<EObject> getSelectedModelElementList();
}
