/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal;

import static org.fortiss.tooling.kernel.ToolingKernel.printPhase;

/**
 * Implementations for initializing and starting the UI part of the tooling kernel.
 * 
 * @author hoelzl
 */
public final class ToolingKernelUIInternal {

	/** Initializes the UI services. */
	public static void initializeKernelUI() {
		printPhase("Tooling Kernel UI initializing ...");
		ActionService.getInstance().initializeService();
		ContextMenuService.getInstance().initializeService();
		MarkerService.getInstance().initializeService();
		ModelEditorBindingService.getInstance().initializeService();
		ModelElementHandlerService.getInstance().initializeService();
		NavigatorService.getInstance().initializeService();
		TutorialUIService.getInstance().initializeService();
		printPhase("Tooling Kernel UI initialized.");
	}

	/** Starts the UI services. */
	public static void startKernelUI() {
		printPhase("Tooling Kernel UI starting ...");
		ActionService.getInstance().startService();
		ContextMenuService.getInstance().startService();
		MarkerService.getInstance().startService();
		ModelEditorBindingService.getInstance().startService();
		ModelElementHandlerService.getInstance().startService();
		NavigatorService.getInstance().startService();
		TutorialUIService.getInstance().startService();
		printPhase("Tooling Kernel UI started.");
	}
}
