/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.actions;

import static org.fortiss.tooling.kernel.ui.util.CopyPasteUtils.copyToClipboard;
import static org.fortiss.tooling.kernel.utils.KernelModelElementUtils.topParents;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;

/**
 * Action for copying the current selection.
 * 
 * @author hummel
 * @author hoelzl
 */
public class CopyAction extends EObjectActionBase<EObject> {

	/** Constructor. */
	public CopyAction() {
		super("Copy", PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_TOOL_COPY));
		setId(ActionFactory.COPY.getId());
	}

	/** {@inheritDoc} */
	@Override
	public void run() {
		doCopy(getTargets());
	}

	/** Copy the targets if non empty. */
	public static void doCopy(EList<EObject> targets) {
		if(targets == null || targets.isEmpty()) {
			return;
		}
		copyToClipboard(topParents(targets));
	}

	/** {@inheritDoc} */
	@Override
	protected boolean computeEnabled() {
		return isGlobalCopyPasteActionsVisible();
	}
}
