/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;

/**
 * The {@link UndoAction} uses the {@link ICommandStackService} to determine the
 * enabled state of this action.
 * 
 * @author hoelzl
 */
public class UndoAction extends EObjectActionBase<EObject> {

	/** Constructor. */
	public UndoAction() {
		super("Undo", PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_TOOL_UNDO));
		setId(ActionFactory.UNDO.getId());
	}

	/** {@inheritDoc} */
	@Override
	protected boolean computeEnabled() {
		return isGlobalUndoRedoActionsVisible() &&
				ICommandStackService.getInstance().canUndo(getTarget());
	}

	/** {@inheritDoc} */
	@Override
	public void run() {
		if(getTarget() != null) {
			ICommandStackService.getInstance().undo(getTarget());
		}
	}
}
