/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.fortiss.tooling.kernel.ui.service.IActionService;

/**
 * The action bar contributor for the {@link ExtendableMultiPageEditor}.
 * 
 * @author hummel
 * @author hoelzl
 */
public final class ActionBarContributor extends MultiPageEditorActionBarContributor {
	/** The last editor seen. */
	private IActionContributingEditor lastEditor;

	/**
	 * {@inheritDoc}
	 * <p>
	 * We set those actions shared between all pages of the editor here.
	 * </p>
	 */
	@Override
	public void setActiveEditor(IEditorPart part) {
		Assert.isTrue(part instanceof ExtendableMultiPageEditor,
				"This contributor may only be used for ExtendableMultiPageEditors!");
		IActionService.getInstance().registerGlobalActions(getActionBars());
		super.setActiveEditor(part);
	}

	/** {@inheritDoc} */
	@Override
	public void setActivePage(IEditorPart activeEditor) {
		IActionBars bars = getActionBars();

		// unregister old actions
		if(lastEditor != null) {
			lastEditor.unregisterGlobalActions(bars);
			lastEditor = null;
		}

		if(activeEditor instanceof IActionContributingEditor) {
			lastEditor = (IActionContributingEditor)activeEditor;
			lastEditor.registerGlobalActions(bars);
		}

		bars.updateActionBars();
		bars.getToolBarManager().update(true);
	}
}
