/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.editor;

import org.eclipse.ui.IActionBars;

/**
 * Interface for editors which contribute own actions to the {@link ActionBarContributor}.
 * 
 * @author hoelzl
 */
public interface IActionContributingEditor {
	/**
	 * This method is a hook to register additional actions in an editor.The
	 * implementation of this should match with the implementation of
	 * {@link #unregisterGlobalActions(IActionBars)}.
	 */
	void registerGlobalActions(IActionBars bars);

	/**
	 * This method is a hook to unregister actions registered in
	 * {@link #registerGlobalActions(IActionBars)}.
	 */
	void unregisterGlobalActions(IActionBars bars);
}
