/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

/**
 * {@link IEditorInput} used when opening a {@link ExtendableMultiPageEditor}.
 * 
 * @author hoelzlf
 */
public final class ModelElementEditorInput implements IEditorInput {

	/** The editor input {@link EObject}. */
	private final EObject modelElement;

	/** Stores the model element handler. */
	private final IModelElementHandler<EObject> handler;

	/** Constructor. */
	public ModelElementEditorInput(EObject modelElement) {
		this.modelElement = modelElement;
		this.handler =
				IModelElementHandlerService.getInstance().getModelElementHandler(modelElement);
	}

	/** Returns the editor input's {@link EObject} model element. */
	public EObject getModelElement() {
		return modelElement;
	}

	/** Returns the model element handler. */
	public IModelElementHandler<EObject> getModelElementHandler() {
		return handler;
	}

	/** {@inheritDoc} */
	@Override
	public boolean equals(Object obj) {
		return obj instanceof ModelElementEditorInput &&
				((ModelElementEditorInput)obj).getModelElement().equals(modelElement);
	}

	/** {@inheritDoc} */
	@Override
	public <S> S getAdapter(Class<S> adapter) {
		return null;
	}

	/** {@inheritDoc} */
	@Override
	public boolean exists() {
		return modelElement.eContainer() != null;
	}

	/** {@inheritDoc} */
	@Override
	public ImageDescriptor getImageDescriptor() {
		return handler.getIconImageDescriptor(modelElement);
	}

	/** {@inheritDoc} */
	@Override
	public String getName() {
		return handler.getName(modelElement);
	}

	/** {@inheritDoc} */
	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	/** {@inheritDoc} */
	@Override
	public String getToolTipText() {
		return handler.getDescription(modelElement);
	}

	/** {@inheritDoc} */
	@Override
	public int hashCode() {
		return super.hashCode();
	}
}
