/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.editor;

import org.conqat.ide.commons.ui.editor.ReadonlyEditorBase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.fortiss.tooling.kernel.ui.ESharedImages;
import org.fortiss.tooling.kernel.ui.extension.ITutorialStepUI;
import org.fortiss.tooling.kernel.ui.extension.base.TutorialStepUICompositeBase;

/**
 * {@link EditorPart} for {@link TutorialStepUICompositeBase} read-only editors.
 * 
 * @author hoelzl
 */
public final class TutorialStepUIEditor extends ReadonlyEditorBase {

	/** {@inheritDoc} */
	@Override
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		if(input instanceof TutorialStepUIEditorInput) {
			setSite(site);
			setInput(input);
			ITutorialStepUI step = ((TutorialStepUIEditorInput)input).getStep();
			setPartName(step.getShortTitle());
			setTitleImage(ESharedImages.TUTORIAL_TODO.getImage());
		} else {
			throw new PartInitException(
					"Tutorial step editor initialized with wrong editor input object.");
		}
	}

	/** {@inheritDoc} */
	@Override
	public void createPartControl(Composite parent) {
		ITutorialStepUI step = ((TutorialStepUIEditorInput)getEditorInput()).getStep();
		step.createDetailsComposite(parent);
	}

	/** {@inheritDoc} */
	@Override
	public void setFocus() {
		// do nothing
	}
}
