/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.fortiss.tooling.kernel.ui.ToolingKernelUIActivator;
import org.fortiss.tooling.kernel.ui.extension.ITutorialStepUI;

/**
 * {@link IEditorInput} for {@link TutorialStepUIEditorInput}.
 * 
 * @author hoelzl
 */
public final class TutorialStepUIEditorInput implements IEditorInput {

	/** The underlying {@link ITutorialStepUI}. */
	private final ITutorialStepUI step;

	/** Constructor. */
	public TutorialStepUIEditorInput(ITutorialStepUI step) {
		this.step = step;
	}

	/** Returns step. */
	public ITutorialStepUI getStep() {
		return step;
	}

	/** {@inheritDoc} */
	@Override
	public <S> S getAdapter(Class<S> adapter) {
		return null;
	}

	/** {@inheritDoc} */
	@Override
	public boolean exists() {
		return false;
	}

	/** {@inheritDoc} */
	@Override
	public ImageDescriptor getImageDescriptor() {
		return ToolingKernelUIActivator.getImageDescriptor("icons/tutorial.gif");
	}

	/** {@inheritDoc} */
	@Override
	public String getName() {
		return step.getTitle();
	}

	/** {@inheritDoc} */
	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	/** {@inheritDoc} */
	@Override
	public String getToolTipText() {
		return "";
	}
}
