/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * Perspective to directly access Eclipse resources (which are used as back-end by
 * {@code EclipseResourceStorageProvider}).
 * 
 * @author hoelzl
 */
public class StoragePerspective implements IPerspectiveFactory {

	/** The ID of this perspective. */
	public static final String ID = StoragePerspective.class.getName();

	/** {@inheritDoc} */
	@Override
	public void createInitialLayout(IPageLayout layout) {
		IFolderLayout left =
				layout.createFolder("left", IPageLayout.LEFT, 0.2f, layout.getEditorArea());
		// Although it is deprecated, using the resource navigator in the storage
		// perspective is sufficient (from the point of requirements for this perspective).
		// See: IPageLayout.ID_RES_NAV.
		left.addView("org.eclipse.ui.views.ResourceNavigator");

		IFolderLayout bottom =
				layout.createFolder("bottom", IPageLayout.BOTTOM, 0.75f, layout.getEditorArea());
		bottom.addView(IPageLayout.ID_PROP_SHEET);
		bottom.addView(IPageLayout.ID_PROGRESS_VIEW);
	}
}
