/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.properties;

import static org.fortiss.tooling.kernel.ui.util.DataBindingUtils.observeText;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

/**
 * Property section for {@link IIdLabeled} objects.
 * 
 * @author hoelzl
 */
public class IdLabeledPropertySection extends PropertySectionBase {

	/** The viewed object. */
	private IIdLabeled idLabeled;

	/** The text used for showing the ID. */
	private Text idText;

	/** {@inheritDoc} */
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		idText = createFormText("ID");
		idText.setEditable(false);
	}

	/** {@inheritDoc} */
	@Override
	protected void setSectionInput(Object input) {
		idLabeled = (IIdLabeled)input;
	}

	/** {@inheritDoc} */
	@Override
	public void refresh() {
		super.refresh();

		IObservableValue<?> modelObservable = ObservableUtils.observeValue(idLabeled,
				FortissToolingKernelPackage.Literals.IID_LABELED__ID);
		dbc.bindValue(observeText(idText, SWT.None), modelObservable, null, null);
	}
}
