/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.properties;

import static org.fortiss.tooling.kernel.ui.util.DataBindingUtils.observeText;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.internal.ActionService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

/**
 * Property section for {@link INamedCommentedElement} objects.
 * 
 * @author ratiu
 */
public class NamedCommentedPropertySection extends PropertySectionBase {

	/** Name edit widget. */
	private Text nameText;

	/** Comment edit widget. */
	private Text commentText;

	/** Model object. */
	protected INamedCommentedElement namedCommented;

	/** Constructor. */
	public NamedCommentedPropertySection() {
		super();
	}

	/** {@inheritDoc} */
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		nameText = createFormText("Name");
		commentText = createFormText("Comment");
	}

	/** {@inheritDoc} */
	@Override
	protected void setSectionInput(Object input) {
		namedCommented = (INamedCommentedElement)input;

		// "Re-target" section
		IModelElementHandlerService hs = IModelElementHandlerService.getInstance();
		IModelElementHandler<EObject> handler = hs.getModelElementHandler(namedCommented);
		if(handler != null) {
			EObject retarget = handler.getPropertySectionRetargetElement(namedCommented);
			if(retarget instanceof INamedCommentedElement) {
				namedCommented = (INamedCommentedElement)retarget;
			}
			addTitleSyncAdapter(namedCommented);
		}
	}

	/** {@inheritDoc} */
	@Override
	public void refresh() {
		super.refresh();

		IObservableValue<?> modelObservable = ObservableUtils.observeValue(namedCommented,
				FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME);
		dbc.bindValue(observeText(nameText, SWT.Modify), modelObservable, null, null);
		modelObservable = ObservableUtils.observeValue(namedCommented,
				FortissToolingKernelPackage.Literals.INAMED_COMMENTED_ELEMENT__COMMENT);
		dbc.bindValue(observeText(commentText, SWT.Modify), modelObservable, null, null);

		// Set focus on "name" text editor and pre-select everything in case a RenameAction is in
		// progress.
		if(ActionService.getInstance().globalRenameAction.isRenameInProgress()) {
			nameText.setFocus();
			nameText.selectAll();
		}
	}
}
