/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.properties;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.util.PropertiesConstantUtils;

/**
 * Adapter factory for tabbed property sheets.
 * 
 * @author hoelzl
 */
public final class PropertiesAdapterFactory implements IAdapterFactory {
	/** {@inheritDoc} */
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
		if(adapterType == ITabbedPropertySheetPageContributor.class &&
				adaptableObject instanceof EObject) {
			EObject modelElement = (EObject)adaptableObject;
			if(IPersistencyService.getInstance().getTopLevelElementFor(modelElement) != null) {
				return (T)new ITabbedPropertySheetPageContributor() {

					@Override
					public String getContributorId() {
						return PropertiesConstantUtils.TABBED_PROPERTY_CONTRIBUTOR_ID;
					}
				};
			}
		}
		return null;
	}

	/** {@inheritDoc} */
	@Override
	public Class<?>[] getAdapterList() {
		return new Class[] {ITabbedPropertySheetPageContributor.class};
	}
}
