/*-------------------------------------------------------------------------+
| Copyright 2012 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.extension.ITutorialStepUI;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.ui.service.ITutorialUIService;
import org.fortiss.tooling.kernel.ui.util.EObjectSelectionUtils;

/**
 * Double-click listener for navigator and marker view.
 * 
 * @author hoelzl
 */
public class DoubleClick implements IDoubleClickListener {

	/** Stores the use-raw-eobject flag. */
	private final boolean useRawEObject;

	/** Constructor. */
	public DoubleClick() {
		this(false);
	}

	/** Constructor. */
	public DoubleClick(boolean useRawEObject) {
		this.useRawEObject = useRawEObject;
	}

	/** {@inheritDoc} */
	@Override
	public void doubleClick(DoubleClickEvent event) {
		// delegate to the editor service
		if(event.getSelection() instanceof IStructuredSelection) {
			EObject element = getDoubleClickedElement((IStructuredSelection)event.getSelection());
			if(element != null) {
				if(!useRawEObject) {
					IModelElementHandler<EObject> handler = IModelElementHandlerService
							.getInstance().getModelElementHandler(element);
					if(handler != null) {
						element = handler.handleOpenModelElementRequest(element);
					}
				}
				IModelEditorBindingService.getInstance().openInEditor(element);
			} else {
				Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
				if(selected instanceof ITutorialStepUI) {
					ITutorialUIService.getInstance().openInEditor((ITutorialStepUI)selected);
				}
			}
		}
	}

	/**
	 * Returns the element to be considered the target of the double click.
	 * Sub-classes may override. The default uses the first element of the given
	 * selection.
	 */
	protected EObject getDoubleClickedElement(IStructuredSelection selection) {
		return EObjectSelectionUtils.getFirstElement(selection);
	}
}
