/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.fortiss.tooling.kernel.ui.internal.editor.ModelElementEditorInput;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;

/**
 * {@link IPartListener2} for the link with editor feature of the navigator.
 * 
 * @author hoelzl
 */
final class LinkWithEditorPartListener implements IPartListener2 {

	/** {@inheritDoc} */
	@Override
	public void partActivated(IWorkbenchPartReference partRef) {
		revealModelElementInNavigator(partRef);
	}

	/** {@inheritDoc} */
	@Override
	public void partInputChanged(IWorkbenchPartReference partRef) {
		revealModelElementInNavigator(partRef);
	}

	/** Calls {@link INavigatorService} to reveal the editor input element. */
	private void revealModelElementInNavigator(IWorkbenchPartReference partRef) {
		if(partRef instanceof IEditorReference) {
			IEditorPart editor = ((IEditorReference)partRef).getEditor(true);
			if(editor.getEditorInput() instanceof ModelElementEditorInput) {
				EObject editorInput =
						((ModelElementEditorInput)editor.getEditorInput()).getModelElement();
				INavigatorService.getInstance().revealModelElement(editorInput);
			}
		}
	}

	/** {@inheritDoc} */
	@Override
	public void partBroughtToTop(IWorkbenchPartReference partRef) {
		// ignore
	}

	/** {@inheritDoc} */
	@Override
	public void partClosed(IWorkbenchPartReference partRef) {
		// ignore
	}

	/** {@inheritDoc} */
	@Override
	public void partDeactivated(IWorkbenchPartReference partRef) {
		// ignore
	}

	/** {@inheritDoc} */
	@Override
	public void partOpened(IWorkbenchPartReference partRef) {
		// ignore
	}

	/** {@inheritDoc} */
	@Override
	public void partHidden(IWorkbenchPartReference partRef) {
		// ignore
	}

	/** {@inheritDoc} */
	@Override
	public void partVisible(IWorkbenchPartReference partRef) {
		// ignore
	}
}
