/*-----------------------------------------------------------------------+
 | org.fortiss.tooling.kernel.ui.internal.views                          |
 |                                                                       |
 |                                                                       |
 | Copyright (c)  2004-2008 Technische Universitaet Muenchen             |
 |                                                                       |
 | Technische Universitaet Muenchen               #########  ##########  |
 | Institut fuer Informatik - Lehrstuhl IV           ##  ##  ##  ##  ##  |
 | Prof. Dr. Manfred Broy                            ##  ##  ##  ##  ##  |
 | Boltzmannstr. 3                                   ##  ##  ##  ##  ##  |
 | 85748 Garching bei Muenchen                       ##  ##  ##  ##  ##  |
 | Germany                                           ##  ######  ##  ##  |
 +-----------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views;

import java.util.Collections;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;

/**
 * The contributor for the dynamic new menu of the navigator view based on model
 * element composition.
 * 
 * @author hoelzl
 */
public class NavigatorNewMenu extends GenericNewMenu {

	/** {@inheritDoc} */
	@Override
	public List<IContributionItem> getContributedItems(EObject selectedObject,
			ContextMenuContextProvider contextProvider) {
		if(!INavigatorService.getInstance().isNavigatorView(contextProvider) ||
				selectedObject == null) {
			return Collections.emptyList();
		}
		boolean isExpertModeActive = ((NavigatorViewPart)contextProvider).isExpertViewActive();
		return getContributedItems(selectedObject, isExpertModeActive);
	}
}
