/*-------------------------------------------------------------------------+
| Copyright 2012 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.fortiss.tooling.kernel.extension.data.TutorialCompositeStep;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

/**
 * {@link ViewerComparator} for the {@link NavigatorViewPart}.
 * 
 * @author hoelzl
 */
public class NavigatorTreeContentComparator extends ViewerComparator {

	/** {@inheritDoc} */
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		if(e1 instanceof TutorialCompositeStep && e2 instanceof EObject) {
			return -1;
		}
		if(e1 instanceof EObject && e2 instanceof TutorialCompositeStep) {
			return 1;
		}
		if(e1 instanceof EObject && e2 instanceof EObject) {
			IModelElementHandler<EObject> handler1 =
					IModelElementHandlerService.getInstance().getModelElementHandler((EObject)e1);
			IModelElementHandler<EObject> handler2 =
					IModelElementHandlerService.getInstance().getModelElementHandler((EObject)e2);
			int w1 = 100000000;
			if(handler1 != null) {
				w1 = handler1.getNavigatorViewWeight((EObject)e1);
			}
			int w2 = 100000000;
			if(handler2 != null) {
				w2 = handler2.getNavigatorViewWeight((EObject)e2);
			}
			int result = w1 - w2;
			if(result == 0) {
				return super.compare(viewer, e1, e2);
			}
			return result;
		}
		return super.compare(viewer, e1, e2);
	}
}
