/*-------------------------------------------------------------------------+
| Copyright 2020 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views.marker;

import static org.fortiss.tooling.kernel.extension.data.IConstraintViolation.ESeverity.getIntSeverity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation.ESeverity;
import org.fortiss.tooling.kernel.ui.service.IMarkerService;

/**
 * Content provider for the error marker view.
 * 
 * @author abid
 */
public class MarkerViewContentProvider extends DynamicTreeContentProviderBase<Object> {

	/** {@inheritDoc} */
	@SuppressWarnings("unchecked")
	@Override
	public Collection<? extends Object> getChildren(Object parent) {

		if(parent instanceof Map<?, ?>) {
			Map<ESeverity, Boolean> statusEntries = (Map<ESeverity, Boolean>)parent;

			// Sort the entries types according to the severity levels to have later a meaningful
			// display order (first FATAL, then ERROR, WARNING, INFO and at the end/bottom DEBUG)
			List<Map.Entry<ESeverity, Boolean>> orderedStatusEntries =
					new ArrayList<>(statusEntries.entrySet());
			orderedStatusEntries.sort((mapEntry1, mapEntry2) -> Integer.compare(
					getIntSeverity(mapEntry1.getKey()), getIntSeverity(mapEntry2.getKey())));

			Collection<IConstraintViolation<?>> rval = new ArrayList<IConstraintViolation<?>>();
			IMarkerService ms = IMarkerService.getInstance();
			for(Entry<ESeverity, Boolean> statusEntry : orderedStatusEntries) {
				// Only display selected severity types
				if(statusEntry.getValue()) {
					rval.addAll(ms.getAllViolationsWithSeverity(statusEntry.getKey()));
				}
			}
			return rval;
		}
		return null;
	}
}
