/*-------------------------------------------------------------------------+
| Copyright 2020 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views.marker;

import java.util.HashMap;
import java.util.Map;

import org.fortiss.tooling.common.ui.javafx.AF3FXViewPart;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation.ESeverity;

/**
 * JavaFX view part of the Marker View.
 * 
 * Wrapper for the {@link MarkerViewPart}. This class can be referenced in the
 * {@code plugin.xml} file to register the view.
 * 
 * @author abid
 */
public class MarkerViewPart extends AF3FXViewPart {

	/** The classes ID. */
	public static final String ID = MarkerViewPart.class.getName();

	/** Stores the toggle state of for each severity level. */
	private static Map<ESeverity, Boolean> toggleState = new HashMap<ESeverity, Boolean>();

	/** Constructor. */
	public MarkerViewPart() throws Exception {
		super(new MarkerViewController(toggleState), null);
	}

	/** Returns toggleState. */
	/* package */Boolean getToggleState(ESeverity sev) {
		return toggleState.get(sev);
	}
}
