/*-------------------------------------------------------------------------+
| Copyright 2020 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.internal.views.marker;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

import javafx.scene.control.ContextMenu;

/**
 * UI (label) provider for the marker view.
 * 
 * @author abid
 */
public class MarkerViewUIProvider extends DynamicTreeTableUIProviderBase<Object> {

	/** {@inheritDoc} */
	@Override
	/** {@inheritDoc} */
	public void updateValue(Object element, int column, Object value) {
		if(column == 0 && element instanceof INamedCommentedElement) {
			INamedCommentedElement elem = (INamedCommentedElement)element;
			ICommandStackService.getInstance().runAsCommand(elem, () -> {
				elem.setComment((String)value);
			});
		}
	}

	/** {@inheritDoc} */
	@Override
	public ContextMenu createContextMenu(Object element, int col) {
		if(element == null || col != 0) {
			return null;
		}
		ContextMenu menu = new ContextMenu();
		return menu;
	}

	/** {@inheritDoc} */
	@Override
	public String getLabel(Object element, int col) {
		IConstraintViolation<?> violation = (IConstraintViolation<?>)element;
		if(element instanceof IConstraintViolation) {
			switch(col) {
				case 0: // Severity Column
					return violation.getSeverity().toString();
				case 1: // Element Column
					IModelElementHandlerService hs = IModelElementHandlerService.getInstance();
					IModelElementHandler<EObject> handler =
							hs.getModelElementHandler(violation.getSource());
					if(handler != null) {
						return handler.getName(violation.getSource());
					}
				case 2: // Explanation Column
					return violation.getExplanation();
				case 3: // Project Column
					IPersistencyService ps = IPersistencyService.getInstance();
					ITopLevelElement topElement = ps.getTopLevelElementFor(violation.getSource());
					IModelElementHandler<EObject> handler_prj = null;
					EObject rootElement = null;
					if(topElement != null) {
						rootElement = topElement.getRootModelElement();
						IModelElementHandlerService hs_prj =
								IModelElementHandlerService.getInstance();
						handler_prj = hs_prj.getModelElementHandler(rootElement);
					}
					return(handler_prj != null ? handler_prj.getName(rootElement) : "");
			}
		}
		return "";
	}
}
