/*******************************************************************************
 * Copyright (c) 2019 fortiss GmbH. 
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection;

import static javafx.scene.input.Clipboard.getSystemClipboard;

import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

/** Helper class for copying a class name to the system clipboard. */
public final class ClipboardCopyHelper {
	/** Creates a context menu to copy the given class name. */
	public static ContextMenu createCopyClassNameMenu(Class<?> toCopy) {
		return createCopyClassNameMenu(toCopy.getName());
	}

	/** Creates a context menu to copy the given class name. */
	public static ContextMenu createCopyClassNameMenu(String fullyQualified) {
		return createContextMenu("Copy '" + fullyQualified + "' to clipboard.", fullyQualified);
	}

	/** Creates a context menu to copy the stack trace of the given {@link Throwable}. */
	public static ContextMenu createCopyStrackTraceMenu(Throwable throwable) {
		StringBuilder sb = new StringBuilder();
		for(StackTraceElement ste : throwable.getStackTrace()) {
			sb.append(ste.toString()).append('\n');
		}
		return createContextMenu("Copy Stack Trace", sb.toString());
	}

	/** Creates the context menu. */
	private static ContextMenu createContextMenu(String label, String data) {
		ContextMenu menu = new ContextMenu();
		MenuItem item = new MenuItem(label);
		item.setOnAction(event -> {
			Clipboard clipboard = getSystemClipboard();
			ClipboardContent content = new ClipboardContent();
			content.putString(data);
			clipboard.setContent(content);
		});
		menu.getItems().add(item);
		return menu;
	}
}
