/*-------------------------------------------------------------------------+
| Copyright 2020 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.introspection;

import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;

import javafx.scene.Node;

/**
 * Abstract class specifying the functionality to be provided by a controller to be contained in a
 * {@link KISSController}-based view.
 * 
 * @author munaro
 */
@SuppressWarnings("unchecked")
public abstract class KISSCompositeFXController<T extends Node>
		extends CompositeFXControllerBase<T, Node> {

	/**
	 * This method is executed each time the {@link IIntrospectionItem} selected in the
	 * {@link KISSController}'s {@link DynamicTreeTableViewer} changes.
	 */
	public abstract void changed(IIntrospectionItem selection);
}
