/*-------------------------------------------------------------------------+
| Copyright 2020 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.introspection;

import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.ui.introspection.details.DetailsUIHandlerBase;
import org.fortiss.tooling.kernel.ui.introspection.details.KISSDetailsUIRegistry;

import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

/**
 * Controller for the view for the detailed inspection of KISS services.
 * 
 * @author munaro
 */
public class KISSServicesController extends KISSCompositeFXController<VBox> {

	/** {@link BorderPane} displaying the description and the details of the selected service. */
	@FXML
	private BorderPane borderPane;

	/** {@link VBox} displaying the description of the selected service. */
	@FXML
	private VBox vBox;

	/** The description label at the bottom. */
	@FXML
	private Label label;

	/** The greeting text. */
	static final String GREETING =
			"Welcome to KISS!\n\nThis is the kernel introspection system service.";

	/** {@inheritDoc} */
	@Override
	public String getFXMLLocation() {
		return "KISSServices.fxml";
	}

	/** {@inheritDoc} */
	@Override
	public void initialize() {
		// nothing to do
	}

	/** {@inheritDoc} */
	@Override
	public void changed(IIntrospectionItem selection) {
		Node center = new Label("No details available!");
		String descr = GREETING;
		if(selection instanceof IIntrospectiveKernelService) {
			IIntrospectiveKernelService ks = (IIntrospectiveKernelService)selection;
			descr = ks.getIntrospectionDescription();
			IIntrospectionDetailsItem item = ks.getDetailsItem();
			if(item != null) {
				DetailsUIHandlerBase handler =
						KISSDetailsUIRegistry.getInstance().getHandler(item.getClass());
				if(handler != null) {
					handler.setService(ks);
					handler.setDataItem(item);
					center = handler.createDisplayControl();
				}
			}
		}
		label.setText(descr);
		borderPane.setCenter(center);
	}
}
