/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details;

import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.KernelIntrospectionSystemService;

import javafx.scene.Node;

/**
 * Base class for factory implementations of the details view of the
 * {@link KernelIntrospectionSystemService} GUI.
 * 
 * @author hoelzl
 */
public abstract class DetailsUIHandlerBase {
	/** The {@link IIntrospectionDetailsItem data item}. */
	protected IIntrospectiveKernelService service;
	/** The {@link IIntrospectionDetailsItem data item}. */
	protected IIntrospectionDetailsItem dataItem;

	/** Sets the data item. */
	public final void setDataItem(IIntrospectionDetailsItem dataItem) {
		this.dataItem = dataItem;
	}

	/** Sets the service. */
	public final void setService(IIntrospectiveKernelService service) {
		this.service = service;
	}

	/** Creates the control for the details display. */
	public abstract Node createDisplayControl();
}
