/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details;

import java.util.HashMap;

import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.items.ConnectionCompositorKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.ConstraintCheckerKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.EclipseResourceStorageKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.ElementCompositorKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.MigrationKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.PersistencyKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.PrototypeKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.TransformationKISSDetailsItem;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.ConnectionCompositorKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.ConstraintCheckerKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.ContextMenuKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.EclipseResourceStorageKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.ElementCompositorKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.MigrationKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.ModelEditorBindingKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.ModelElementHandlerKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.PersistencyKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.PrototypeKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.details.handler.TransformationKISSDetailsUIHandler;
import org.fortiss.tooling.kernel.ui.introspection.items.ContextMenuKISSDetailsItem;
import org.fortiss.tooling.kernel.ui.introspection.items.ModelEditorBindingKISSDetailsItem;
import org.fortiss.tooling.kernel.ui.introspection.items.ModelElementHandlerKISSDetailsItem;

/** Registry class to provide the details GUI for a given {@link IIntrospectionItem}. */
public final class KISSDetailsUIRegistry {

	/** Returns the singleton instance of the service. */
	private static final KISSDetailsUIRegistry INSTANCE = new KISSDetailsUIRegistry();

	/** Returns the singleton instance. */
	public static KISSDetailsUIRegistry getInstance() {
		return INSTANCE;
	}

	/** The registry. */
	private final HashMap<Class<? extends IIntrospectionDetailsItem>, DetailsUIHandlerBase> registry =
			new HashMap<Class<? extends IIntrospectionDetailsItem>, DetailsUIHandlerBase>();

	/** Constructor. */
	public KISSDetailsUIRegistry() {
		registerHandler(ConnectionCompositorKISSDetailsItem.class,
				new ConnectionCompositorKISSDetailsUIHandler());
		registerHandler(ConstraintCheckerKISSDetailsItem.class,
				new ConstraintCheckerKISSDetailsUIHandler());
		registerHandler(ContextMenuKISSDetailsItem.class, new ContextMenuKISSDetailsUIHandler());
		registerHandler(EclipseResourceStorageKISSDetailsItem.class,
				new EclipseResourceStorageKISSDetailsUIHandler());
		registerHandler(ElementCompositorKISSDetailsItem.class,
				new ElementCompositorKISSDetailsUIHandler());
		registerHandler(MigrationKISSDetailsItem.class, new MigrationKISSDetailsUIHandler());
		registerHandler(ModelEditorBindingKISSDetailsItem.class,
				new ModelEditorBindingKISSDetailsUIHandler());
		registerHandler(ModelElementHandlerKISSDetailsItem.class,
				new ModelElementHandlerKISSDetailsUIHandler());
		registerHandler(PrototypeKISSDetailsItem.class, new PrototypeKISSDetailsUIHandler());
		registerHandler(PersistencyKISSDetailsItem.class, new PersistencyKISSDetailsUIHandler());
		registerHandler(TransformationKISSDetailsItem.class,
				new TransformationKISSDetailsUIHandler());
	}

	/** Registers the given composite */
	public void registerHandler(Class<? extends IIntrospectionDetailsItem> clazz,
			DetailsUIHandlerBase detailsHandler) {
		registry.put(clazz, detailsHandler);
	}

	/** Returns the composite factory for the given class. */
	public DetailsUIHandlerBase getHandler(Class<? extends IIntrospectionDetailsItem> clazz) {
		return registry.get(clazz);
	}
}
