/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details.handler;

import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.introspection.items.ConnectionCompositorKISSDetailsItem;
import org.fortiss.tooling.kernel.introspection.items.EObjectAware2KISSDetailsItemBase;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;

import javafx.scene.Node;

/**
 * Introspection UI handler for the {@link IConnectionCompositorService}.
 * 
 * @author hoelzl
 */
public final class ConnectionCompositorKISSDetailsUIHandler
		extends EObjectAware2KISSDetailsUIHandlerBase {
	/** {@inheritDoc} */
	@Override
	public Node createDisplayControl() {
		String heading = "Type to search registered connection compositors:";
		String footer = "Number of currently registered connection compositors: " +
				getRootObject().countHandlers();
		return createFilteredTree(heading, footer);
	}

	/** {@inheritDoc} */
	@Override
	protected void createTreeColumns(DynamicTreeTableViewer<Object> tree) {
		createDefaultTreeColumns(tree, "Source / Target / Compositor", 250, "Compositor Class", 400,
				"Source EObject Class", 400, "Target EObject Class", 400);
	}

	/** {@inheritDoc} */
	@Override
	protected DynamicTreeContentProviderBase<Object> createContentProvider() {
		return new EObjectAware2TreeContentProviderBase() {
			@Override
			protected EObjectAware2KISSDetailsItemBase<?> getInputObject() {
				return ConnectionCompositorKISSDetailsUIHandler.this.getRootObject();
			}
		};
	}

	/** {@inheritDoc} */
	@Override
	protected ConnectionCompositorKISSDetailsItem getRootObject() {
		return (ConnectionCompositorKISSDetailsItem)dataItem;
	}
}
