/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details.handler;

import java.util.Collection;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.extension.IConstraintChecker;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.items.ConstraintCheckerKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IConstraintCheckerService;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;

/**
 * Introspection UI handler for {@link IIntrospectionItem}s provided by
 * {@link IConstraintCheckerService}.
 * 
 * @author hoelzl
 */
public final class ConstraintCheckerKISSDetailsUIHandler extends KISSDetailsUIHandlerBase {
	/** {@inheritDoc} */
	@Override
	public Node createDisplayControl() {
		String h = "Type to search registered checkers:";
		String f = "Number of registered constraint checkers: " + countCheckers();
		return createFilteredTree(h, f);
	}

	/** Computes the number of constraint checkers. */
	private int countCheckers() {
		int count = 0;
		for(Class<?> c : getRootObject().getHandlerKeyClasses()) {
			count += getRootObject().getHandlerList(c).size();
		}
		return count;
	}

	/** {@inheritDoc} */
	@Override
	protected void createTreeColumns(DynamicTreeTableViewer<Object> tree) {
		tree.addColumn("Model Element / Checker", 400);
		tree.addColumn("Model Element Class", 400);
		tree.addColumn("Constraint Checker Implementation Class", 400);
	}

	/** {@inheritDoc} */
	@Override
	protected DynamicTreeContentProviderBase<Object> createContentProvider() {
		return new DynamicTreeContentProviderBase<Object>() {
			/** {@inheritDoc} */
			@Override
			protected Collection<? extends Object> getChildren(Object parent) {
				if(parent == getRootObject()) {
					return getRootObject().getHandlerKeyClasses();
				} else if(parent instanceof Class) {
					return getRootObject().getHandlerList((Class<?>)parent);
				}
				return null;
			}
		};
	}

	/** {@inheritDoc} */
	@SuppressWarnings("unchecked")
	@Override
	protected DynamicTreeTableUIProviderBase<Object> createUIProvider() {
		return new DynamicTreeTableUIProviderBase<Object>() {
			@Override
			public Node getIconNode(Object element, int column) {
				return null;
			}

			@Override
			public String getLabel(Object data, int column) {
				if(data instanceof Class) {
					switch(column) {
						case 0:
							return ((Class<?>)data).getSimpleName();
						case 1:
							return ((Class<?>)data).getName();
					}
				} else if(data instanceof IConstraintChecker) {
					IConstraintChecker<EObject> icc = (IConstraintChecker<EObject>)data;
					switch(column) {
						case 0:
							return icc.getClass().getSimpleName();
						case 2:
							return icc.getClass().getName();
					}
				}
				return null;
			}

			/** {@inheritDoc} */
			@Override
			public ContextMenu createContextMenu(Object element, int column) {
				if(element instanceof Class) {
					return createCopyClassNameMenuItem((Class<?>)element);
				}
				if(element instanceof IConstraintChecker<?>) {
					return createCopyClassNameMenuItem(element.getClass());
				}
				return null;
			}
		};
	}

	/** {@inheritDoc} */
	@Override
	protected ConstraintCheckerKISSDetailsItem getRootObject() {
		return (ConstraintCheckerKISSDetailsItem)dataItem;
	}
}
