/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details.handler;

import static java.util.Arrays.asList;
import static java.util.stream.Collectors.toList;

import java.util.Collection;

import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.service.IConstraintCheckerService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.introspection.items.ContextMenuKISSDetailsItem;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;

/**
 * Introspection UI handler for {@link IIntrospectionItem}s provided by
 * {@link IConstraintCheckerService}.
 * 
 * @author hoelzl
 */
public final class ContextMenuKISSDetailsUIHandler extends KISSDetailsUIHandlerBase {
	/** {@inheritDoc} */
	@Override
	public Node createDisplayControl() {
		String h = "Type to search registered menu contributors:";
		String f = "Number of registered menu contributors: " +
				getRootObject().getHandlerList().size();
		return createFilteredTree(h, f);
	}

	/** {@inheritDoc} */
	@Override
	protected void createTreeColumns(DynamicTreeTableViewer<Object> tree) {
		tree.addColumn("Menu Section", 400);
		tree.addColumn("Menu Provider Class", 500);
	}

	/** {@inheritDoc} */
	@Override
	protected DynamicTreeContentProviderBase<Object> createContentProvider() {
		return new DynamicTreeContentProviderBase<Object>() {
			/** {@inheritDoc} */
			@Override
			protected Collection<? extends Object> getChildren(Object parent) {
				if(parent == getRootObject()) {
					return asList(IContextMenuService.MENU_SECTION_IDS);
				} else if(parent instanceof String) {
					return getRootObject().getHandlerList().stream()
							.filter(h -> parent.equals(h.getMenuSectionID())).collect(toList());
				}
				return null;
			}
		};
	}

	/** {@inheritDoc} */
	@Override
	protected DynamicTreeTableUIProviderBase<Object> createUIProvider() {
		return new DynamicTreeTableUIProviderBase<Object>() {
			@Override
			public Node getIconNode(Object element, int column) {
				return null;
			}

			@Override
			public String getLabel(Object data, int column) {
				if(data instanceof String && column == 0) {
					return (String)data;
				} else if(data instanceof IContextMenuContributor) {
					IContextMenuContributor icc = (IContextMenuContributor)data;
					switch(column) {
						case 0:
							return icc.getClass().getSimpleName();
						case 1:
							return icc.getClass().getName();
					}
				}
				return null;
			}

			/** {@inheritDoc} */
			@Override
			public ContextMenu createContextMenu(Object element, int column) {
				if(element instanceof IContextMenuContributor) {
					return createCopyClassNameMenuItem(element.getClass());
				}
				return null;
			}
		};
	}

	/** {@inheritDoc} */
	@Override
	protected ContextMenuKISSDetailsItem getRootObject() {
		return (ContextMenuKISSDetailsItem)dataItem;
	}
}
