/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details.handler;

import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.introspection.items.EObjectAwareKISSDetailsItemBase;
import org.fortiss.tooling.kernel.introspection.items.ElementCompositorKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

import javafx.scene.Node;

/**
 * Introspection UI handler for the {@link IElementCompositorService}.
 * 
 * @author hoelzl
 */
public final class ElementCompositorKISSDetailsUIHandler
		extends EObjectAwareKISSDetailsUIHandlerBase {
	/** {@inheritDoc} */
	@Override
	public Node createDisplayControl() {
		String heading = "Type to search registered element compositors:";
		String footer = "Number of currently registered element compositors: " +
				getRootObject().countHandlers();
		return createFilteredTree(heading, footer);
	}

	/** {@inheritDoc} */
	@Override
	protected void createTreeColumns(DynamicTreeTableViewer<Object> viewer) {
		createDefaultTreeColumns(viewer, "Class / Compositor", 250, "Compositor Class", 400,
				"EObject Class", 400);
	}

	/** {@inheritDoc} */
	@Override
	protected DynamicTreeContentProviderBase<Object> createContentProvider() {
		return new EObjectAwareTreeContentProviderBase() {
			@Override
			protected EObjectAwareKISSDetailsItemBase<?> getInputObject() {
				return ElementCompositorKISSDetailsUIHandler.this.getRootObject();
			}
		};
	}

	/** {@inheritDoc} */
	@Override
	protected ElementCompositorKISSDetailsItem getRootObject() {
		return (ElementCompositorKISSDetailsItem)dataItem;
	}
}
