/*******************************************************************************
 * Copyright (c) 2011, 2018 fortiss GmbH.
 * 
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 *******************************************************************************/
package org.fortiss.tooling.kernel.ui.introspection.details.handler;

import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.introspection.items.EObjectAwareKISSDetailsItemBase;
import org.fortiss.tooling.kernel.introspection.items.MigrationKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IMigrationService;
import org.fortiss.tooling.kernel.ui.introspection.details.DetailsUIHandlerBase;

import javafx.scene.Node;

/**
 * {@link DetailsUIHandlerBase} for {@link IMigrationService}.
 * 
 * @author hoelzl
 */
public class MigrationKISSDetailsUIHandler extends EObjectAwareKISSDetailsUIHandlerBase {
	/** {@inheritDoc} */
	@Override
	public Node createDisplayControl() {
		String heading = "Type to search registered migration providers:";
		String footer = "Number of currently registered migration providers: " +
				getRootObject().countHandlers();
		return createFilteredTree(heading, footer);
	}

	/** {@inheritDoc} */
	@Override
	protected void createTreeColumns(DynamicTreeTableViewer<Object> tree) {
		createDefaultTreeColumns(tree, "Class / Provider", 250, "Provider Class", 400,
				"EObject Class", 400);
	}

	/** {@inheritDoc} */
	@Override
	protected DynamicTreeContentProviderBase<Object> createContentProvider() {
		return new EObjectAwareTreeContentProviderBase() {
			@Override
			protected EObjectAwareKISSDetailsItemBase<?> getInputObject() {
				return MigrationKISSDetailsUIHandler.this.getRootObject();
			}
		};
	}

	/** {@inheritDoc} */
	@Override
	protected MigrationKISSDetailsItem getRootObject() {
		return (MigrationKISSDetailsItem)dataItem;
	}
}
