/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.presentation;

import static org.fortiss.tooling.kernel.ui.ToolingKernelUIActivator.getDefault;
import static org.fortiss.tooling.kernel.ui.util.EObjectSelectionUtils.getFirstElement;
import static org.fortiss.tooling.kernel.utils.LoggingUtils.error;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

/**
 * Label provider for model elements that have corresponding handlers.
 * 
 * @author mou
 */
public class ModelElementLabelProvider extends ColumnLabelProvider {
	/** {@inheritDoc} */
	@Override
	public String getText(Object element) {
		if(element instanceof EObject) {
			IModelElementHandler<EObject> handler = IModelElementHandlerService.getInstance()
					.getModelElementHandler((EObject)element);

			if(handler != null)
				return handler.getName((EObject)element);
			// try to fall back on INamedElementModel
			if(element instanceof INamedElement) {
				return ((INamedElement)element).getName();
			}
			error(getDefault(),
					"Missing model element handler of non-INamedElement EObject of class " +
							element.getClass());
		} else if(element instanceof IStructuredSelection) {
			return getText(getFirstElement((IStructuredSelection)element));
		}
		return super.getText(element);
	}

	/** {@inheritDoc} */
	@Override
	public Image getImage(Object element) {
		if(element instanceof EObject) {
			IModelElementHandler<EObject> handler = IModelElementHandlerService.getInstance()
					.getModelElementHandler((EObject)element);

			if(handler != null) {
				return handler.getIcon((EObject)element);
			}
		} else if(element instanceof IStructuredSelection) {
			return getImage(getFirstElement((IStructuredSelection)element));
		}
		return super.getImage(element);
	}
}
