/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.presentation;

import org.eclipse.swt.graphics.Image;
import org.fortiss.tooling.kernel.extension.data.TutorialStepBase;
import org.fortiss.tooling.kernel.service.ITutorialService;
import org.fortiss.tooling.kernel.ui.ESharedImages;

/**
 * A {@link ModelElementLabelProvider} that also handles {@link TutorialStepBase}s.
 * 
 * @author hoelzl
 */
public class TutorialDefinitionModelElementLabelProvider
		extends ConstraintViolationAwareLabelProviderBase {

	/** {@inheritDoc} */
	@Override
	public String getText(Object element) {
		if(element instanceof TutorialStepBase) {
			return element instanceof TutorialStepBase ? ((TutorialStepBase)element).getTitle()
					: super.getText(element);
		}
		return super.getText(element);
	}

	/** {@inheritDoc} */
	@Override
	public Image getImage(Object element) {
		if(element instanceof TutorialStepBase) {
			return getTutorialStepImage((TutorialStepBase)element);
		}
		return super.getImage(element);
	}

	/** Returns the image for the tutorial step. */
	private Image getTutorialStepImage(TutorialStepBase element) {
		ITutorialService s = ITutorialService.getInstance();
		if(s.isCompletedStep(element)) {
			return ESharedImages.OK.getImage();
		}
		if(s.getActiveTutorialStep() == element) {
			return ESharedImages.TUTORIAL.getImage();
		}
		return ESharedImages.TUTORIAL_TODO.getImage();
	}
}
