/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.service;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.ui.internal.ActionService;

/**
 * The action service manages registration and execution of actions including
 * global actions like undo, redo, and delete.
 * 
 * @author hoelzl
 */
public interface IActionService {
	/** Returns the service instance. */
	public static IActionService getInstance() {
		return ActionService.getInstance();
	}

	/** Runs the global copy action. */
	public void runGlobalCopyAction();

	/** Runs the global paste action. */
	public void runGlobalPasteAction();

	/** Runs the global delete action. */
	public void runGlobalDeleteAction();

	/** Runs the global undo action. */
	public void runGlobalUndoAction();

	/** Runs the global redo action. */
	public void runGlobalRedoAction();

	/** Runs the global cut action. */
	public void runGlobalCutAction();

	/** Runs the global rename action. */
	public void runGlobalRenameAction();

	/** Runs the global "select all" action. */
	public void runGlobalSelectAllAction();

	/** Registers all global actions with the given {@link IActionBars}. */
	void registerGlobalActions(IActionBars actionBars);

	/**
	 * Registers the global unde/redo action with the given {@link IActionBars}.
	 */
	public void registerGlobalUndoRedoActions(IActionBars actionBars);

	/** Registers the global editing action with the given {@link IActionBars}. */
	public void registerGlobalEditingActions(IActionBars actionBars);

	/**
	 * Adds the global default actions to the given context menu. Currently the
	 * default are the editing actions as provided by #
	 * {@link IActionService#addGlobalEditingActionsToMenu(IMenuManager,boolean,boolean,boolean,boolean)}
	 * .
	 */
	void addGlobalDefaultActionSectionToMenu(IMenuManager menuManager);

	/**
	 * Adds the global editing actions to the menu (Copy, Cut, Paste, Delete, Rename, Select All).
	 */
	void addGlobalEditingActionsToMenu(IMenuManager menuManager, boolean copyPaste, boolean delete,
			boolean rename, boolean selectAll);

	/** Adds the global undo/redo actions to the menu. */
	void addGlobalUndoRedoActionsToMenu(IMenuManager menuManager);

	/**
	 * Refreshes the enabled state of the global actions. This method should be
	 * called when a selection changes. It is automatically called by the action
	 * service when any command stack changes.
	 */
	void refresh();

	/**
	 * Returns whether the given contribution item was provided by the navigator's new menu, i.e.,
	 * there is a prototype offered by the prototype service, which is also composable by the
	 * element compositor service can, and returns the associated prototype.
	 */
	Prototype getNewMenuContributionPrototype(IContributionItem contributionItem);
}
