/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.service;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ui.extension.IModelEditor;
import org.fortiss.tooling.kernel.ui.extension.IModelEditorBinding;
import org.fortiss.tooling.kernel.ui.internal.ModelEditorBindingService;

/**
 * The model editor service handles editor registration. It also allows opening
 * and closing of editors.
 * 
 * @see IModelEditorBinding
 * 
 * @author hoelzl
 */
public interface IModelEditorBindingService {
	/** Returns the service instance. */
	public static IModelEditorBindingService getInstance() {
		return ModelEditorBindingService.getInstance();
	}

	/** Opens an editor for the given element. */
	void openInEditor(EObject element);

	/** Closes editors which depend on the given element or a sub-element. */
	void closeEditors(EObject parentElement);

	/** Closes all editors. */
	void closeAllEditors();

	/** Closes editor of the given element. */
	void closeEditor(EObject element);

	/** Check whether editor of the given element is opened. */
	boolean isOpen(EObject element);

	/** Returns the currently active editor. */
	IModelEditor<EObject> getActiveEditor();

	/** Returns registered editor bindings for the given class. */
	List<IModelEditorBinding<EObject>> getBindings(Class<? extends EObject> elementType);

	/** Returns registered editor bindings for the given {@link EObject}. */
	List<IModelEditorBinding<EObject>> getBindings(EObject element);

	/** Registers the given editor binding with the kernel. */
	<T extends EObject> void registerEditorBinding(IModelEditorBinding<T> binding,
			Class<T> modelElementClass);
}
