/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.service;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.internal.ModelElementHandlerService;

import javafx.scene.Node;

/**
 * The model element handler service provides access to registered model element
 * handlers.
 * 
 * @see IModelElementHandler
 * 
 * @author hoelzl
 */
public interface IModelElementHandlerService {
	/** The view ID of the model element library view. Keep in sync with plugin.xml. */
	public static final String MODEL_ELEMENTS_VIEW =
			"org.fortiss.tooling.kernel.model.elements.view";

	/** Returns the service instance. */
	public static IModelElementHandlerService getInstance() {
		return ModelElementHandlerService.getInstance();
	}

	/**
	 * Returns the model element handler for the given model element or <code>null</code> if no such
	 * handler exists.
	 */
	IModelElementHandler<EObject> getModelElementHandler(EObject modelElement);

	/**
	 * Returns the name of the model element (or <code>null</code> if no handler
	 * was found).
	 */
	String getName(EObject modelElement);

	/**
	 * Returns a description of the model element (or <code>null</code> if no
	 * handler was found).
	 */
	String getDescription(EObject modelElement);

	/**
	 * Returns the icon of the model element (or <code>null</code> if no handler
	 * was found).
	 */
	Image getIcon(EObject modelElement);

	/**
	 * Returns the (JavaFX) icon of the model element (or <code>null</code> if no handler
	 * was found).
	 */
	Node getFXIcon(EObject modelElement);

	/**
	 * Returns a wrapped string built from the name and description returned by
	 * the underlying handler.
	 */
	String getWrappedNameDescription(EObject modelElement);

	/** Registers the given handler with the kernel. */
	<T extends EObject> void registerModelElementHandler(IModelElementHandler<T> handler,
			Class<T> modelElementClass);
}
