/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.service;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.Saveable;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.internal.NavigatorService;

/**
 * The navigator service provides model navigation support. Its main
 * contribution is the navigator Eclipse view, which shows the model content
 * starting with the top-level elements and using the information provided by
 * {@link IModelElementHandlerService}.
 * 
 * <P>
 * The navigator service is also responsible to integrate with the Eclipse IDE regarding model file
 * save support.
 * 
 * <P>
 * The navigator service does not provide any extensions.
 * 
 * @author hoelzl
 */
public interface INavigatorService {
	/** Returns the service instance. */
	public static INavigatorService getInstance() {
		return NavigatorService.getInstance();
	}

	/** Returns view id of the navigator view. */
	public static final String NAVIGATOR_VIEW = "org.fortiss.tooling.kernel.model.navigator";

	/** Returns the current navigator selection. */
	ISelection getCurrentSelection();

	/** Programmatically sets the current navigator selection. */
	void setCurrentSelection(ISelection selection);

	/**
	 * Returns whether the given {@link ContextMenuContextProvider} is equal to
	 * the navigator view part. An {@link IContextMenuContributor} may use this
	 * method to restrict its contributions to the navigator view.
	 */
	boolean isNavigatorView(ContextMenuContextProvider provider);

	/** Returns whether expert view is active. */
	boolean isExpertViewActive();

	/** Returns the saveables. */
	Saveable[] getSaveables();

	/** Returns the saveables of the current selection. */
	Saveable[] getActiveSaveables();

	/** Reveals the given model element. */
	void revealModelElement(EObject modelElement);

	/** Refreshes the navigator view part. */
	void refresh();
}
